package fr.asip.cps3.exemple.vues.ecrans.resultats;

import java.awt.Color;
import java.awt.GridBagLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import fr.asip.cps3.exemple.vues.FenetrePrincipale;
import fr.asip.cps3.exemple.vues.composants.GridBagHelper;
import fr.asip.cps3.exemple.vues.ecrans.EcranUtil;

/**
 * Classe permettant de modliser l'cran de rsultats avec 2 codes retour
 */
public class SortieResultatDouble extends SortieResultat {

	/**
	 * Libell du champ de la deuxime opration
	 */
	protected JLabel libelleOperation2;
	
	/**
	 * Texte du champ de la deuxime opration
	 */
	protected JTextField texteOperation2;
	
	/**
	 * Libell du champ du deuxime code retour
	 */
	protected JLabel libelleCodeRetour2;
	
	/**
	 * Texte du champ du deuxime code retour
	 */
	protected JTextField texteCodeRetour2;	
	
	/**
	 * Constructeur
	 * @param fenetre La fentre qui doit contenir l'cran de rsultat
	 */
	public SortieResultatDouble(FenetrePrincipale fenetre) {

		super(fenetre);

		libelleOperation = new JLabel("Operation 1 : ");
		libelleRetour = new JLabel("Retour 1 : ");
		libelleOperation2 = new JLabel("Operation 2 : ");
		libelleCodeRetour2 = new JLabel("Retour 2 : ");
		
    	texteOperation2 = new JTextField();
    	texteCodeRetour2 = new JTextField();
    	texteOperation2.setEditable(false);
    	texteCodeRetour2.setEditable(false);
    	texteOperation2.setBackground(Color.white);
    	texteCodeRetour2.setBackground(Color.white);
    	
	}
	
	/*
	 * (non-Javadoc)
	 * @see fr.asip.cps3.exemple.vues.ecrans.IEcran#affiche()
	 */
	public void affiche() {
    	
    	JFrame fenetre = this.fenetre.getFenetre();

    	if(fenetre != null && fenetre.getContentPane() != null) {    	
    	
	    	EcranUtil.supprimeTousLesComposants(((JPanel)fenetre.getContentPane()));
	
	    	// Cration du layout
	    	((JPanel)fenetre.getContentPane()).setBorder(new EmptyBorder(0, 0, 0, 0));
	        GridBagLayout layout = new GridBagLayout();
	        ((JPanel)fenetre.getContentPane()).setLayout(layout);
	        
	        // Ajout des composants
	        GridBagHelper g = new GridBagHelper(fenetre.getContentPane());
	        // Ligne 0
	        g.ajoute(libelleOperation, EcranUtil.styleLibelleSortie, 0, 0, 1, 1);
	        g.ajoute(texteOperation, EcranUtil.styleTexteSortie, 0, 1, 1, 4);
	        // Ligne 1
	        g.ajoute(libelleRetour, EcranUtil.styleLibelleSortie, 1, 0, 1, 1);
	        g.ajoute(texteRetour, EcranUtil.styleTexteSortie, 1, 1, 1, 4);
	        // Ligne 2
	        g.ajoute(libelleOperation2, EcranUtil.styleLibelleSortie, 2, 0, 1, 1);
	        g.ajoute(texteOperation2, EcranUtil.styleTexteSortie, 2, 1, 1, 4);
	        // Ligne 3
	        g.ajoute(libelleCodeRetour2, EcranUtil.styleLibelleSortieCodeRetour, 3, 0, 1, 1);
	        g.ajoute(texteCodeRetour2, EcranUtil.styleTexteSortieCodeRetour, 3, 1, 1, 4);
	        // Ligne 4
	        if(barreStatut != null)
	        	barreStatut.setText(this.fenetre.getBarreStatut().getText());
	        g.ajoute(barreStatut, EcranUtil.styleBarreStatut, 4, 0, 1, 6);
	        
    	}

    }

	/**
     * Affecte le texte de la deuxime opration
     * @param operation Le texte de la deuxime opration
     */
	public void setOperation2(String operation2) {
		if(texteOperation2 != null)
			texteOperation2.setText(operation2);
	}

	/**
	 * Affecte le texte du deuxime code retour
	 * @param codeRetour Le texte du deuxime code retour
	 */
	public void setCodeRetour2(String codeRetour2) {
		if(texteCodeRetour2 != null)
			texteCodeRetour2.setText(codeRetour2);		
	}
}
